 /**
 *
 * \file        HPRFGW_RFSlaveIntf.c
 *
 * \brief       This file contains the RF slave interface API functions.
 *
 * \detail
 *
 * \author      Hazrat Shah
 *
 * \date        11/28/2006
 * \warning
 * \note
 * \review
 */

#include "hprfgw_config.h"
// MNT - 3/21/2007 - Dependency Removal tag begin
//#include "console.h"
//#include "hprfgw_eeprom.h"
// MNT - 3/21/2007 - Dependency Removal tag end
#if defined (OS_NUCLEUS)
 #include "cpu.h"
 #include "system.h"
#endif
#include "hprfgw_rfResultCode.h"
#include "hprfgw_rfHeartbeat.h"
#include "hprfgw_rfDesc.h"
#include "hprfgw_rfApp.h"
#include "hprfgw_rfTrans.h"
#include "hprfgw_rfRec.h"
#include "hprfgw_rfRecMsg.h"
#include "hprfgw_rfComLog.h"
#include "hprfgw_rfSlaveIntToHost.h"
#include "hprfgw_rfSlaveIntToRfApp.h"
#if defined (OS_NUCLEUS)
 #include "timer.h"
 #include "tp.h"
 #include "rf_serv.h"
 #include "crc.h"
#endif
#if defined(OS_NUCLEUS) || defined(OS_WINCE)
 #include <stdio.h>
 #include <stdlib.h>
 #include <stdarg.h>
 #include <string.h>
 #include <ctype.h>
 #include <wtypes.h>
#endif
#if defined (OS_WINCE)
#include "winreg.h"
#endif
#include "NvRamInterface.h"
#include "nvram_dataMap.h"


////////////////////////////////////////////////////////////////////////////////
//	EXTERNAL
////////////////////////////////////////////////////////////////////////////////
extern	INT8   *ConvertUIDtoString (UINT8 *puid, INT8 *pstr, UINT8 addrmode);
extern  unsigned short CalculateBlockCRC16(unsigned long count,unsigned short crc,void* buffer);

////////////////////////////////////////////////////////////////////////////////
//	DEFINITIONS
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//	LOCAL DATA
////////////////////////////////////////////////////////////////////////////////
INT32	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *pAddrmode, UINT8 *defUID, UINT16 defPanid, UINT8 defAddrMode);
INT32	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *defUID, UINT16 defPanid);
INT32	HOSTAPPINTERFACE_StoreGatewayUID_PANID(UINT8 *pUID, UINT16 PANID, UINT8 AddrMode);
INT32	HOSTAPPINTERFACE_StoreGatewayName (UINT8 *pName);
INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID(UINT8 *pUID, UINT16 PANID);
INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID(UINT8 *pUID);
INT32	HOSTAPPINTERFACE_StoreLocalDevicePANID(UINT16 PANID);
INT32	HOSTAPPINTERFACE_ProcessCresnetPacket(UINT8 *pBuf, UINT16 BufLen);
INT32	HOSTAPPINTERFACE_LinkReply(BOOL Linked, BOOL CSStatus);
INT32	HOSTAPPINTERFACE_RFCommunicationError(BOOL SeqErr, BOOL SegErr);
INT32	HOSTAPPINTERFACE_BufferOverFlows (BOOL TxBuf, BOOL RxBuf);
INT32	HOSTAPPINTERFACE_EchoReply(UINT8 *pBuf, UINT8 BufLen);
INT32	HOSTAPPINTERFACE_ProcessLocalCresnetPacket(UINT8 *pBuf, UINT16 BufLen);
INT32	HOSTAPPINTERFACE_GetRetryCount(UINT8 *count, UINT8 defCount);
INT32	HOSTAPPINTERFACE_StoreRetryCount(UINT8 count);
INT32	HOSTAPPINTERFACE_GetRetryDelay(UINT8 *RetryDly, UINT8 Cnt, UINT8 *defRetryDly);
INT32	HOSTAPPINTERFACE_StoreRetryDelay(UINT8 RetryDly, UINT8 Cnt);
INT32	HOSTAPPINTERFACE_GetPowerLevel(UINT16 *powerLevel, UINT16 defPowerLevel);
INT32	HOSTAPPINTERFACE_StorePowerLevel(UINT16 powerLevel);
INT32	HOSTAPPINTERFACE_GetChannel	(UINT8 *Channel, UINT8 defChannel);
INT32	HOSTAPPINTERFACE_StoreChannel (UINT8 Channel);
INT32	HOSTAPPINTERFACE_GetCCAEnergyDetectThr(UINT8 *ccaThres, UINT8 defCcaThres);
INT32	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr(UINT8 ccaThres);
INT32	HOSTAPPINTERFACE_GetRSSIPowerCompOffset(UINT8 *rssiOffset, UINT8 defRssiOffset);
INT32	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset(UINT8 rssiOffset);
INT32	HOSTAPPINTERFACE_GetResultCodeTimeout(UINT16 *timeout, UINT16 defTimeout);
INT32	HOSTAPPINTERFACE_StoreResultCodeTimeout(UINT16 timeout);
INT32	HOSTAPPINTERFACE_GetHeartBeatRate(UINT8 *heartBeatRate, UINT8 defHeartBeatRate);
INT32	HOSTAPPINTERFACE_StoreHeartBeatRate(UINT8 heartBeatRate);
INT32	HOSTAPPINTERFACE_GetRFID(UINT8 *rfID);
INT32	HOSTAPPINTERFACE_GetTSID(UINT32 *tsID);
INT32	HOSTAPPINTERFACE_GetIDString(INT8 *pBuf, UINT8 * count);
INT32	HOSTAPPINTERFACE_AcquireUpdate(TYPE_GATEWAY_IN_ACQUIRE_LIST* pAcquireResult, UINT8 NoofAcquireEntries, BOOL Finished);
INT32	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange(BOOL CSStatus, BOOL SendUpdateReq);
INT32	HOSTAPPINTERFACE_GatewayConnectionStatusChange(BOOL CSStatus);
INT32	HOSTAPPINTERFACE_GetDeviceOptions (UINT8 *devOpts);
INT32	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured (UINT32 index);
INT32	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (BOOL *isEnabled);
INT32	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled (BOOL *isEnabled);
INT32   HOSTAPPINTERFACE_RFReceiverIndicatorFlash(void);
INT32   HOSTAPPINTERFACE_RFTransmitIndicatorFlash(void);
INT32	HOSTAPPINTERFACE_DeviceLinkLost (UINT8 rfid);
INT32	HOSTAPPINTERFACE_DeviceLinkFound (UINT8 rfid);
INT32	HOSTAPPINTERFACE_CalculateBlockCRC16 (UINT16 len, UINT16 *crc, INT8 *pbuf);
INT32	HOSTAPPINTERFACE_GetDeviceDataField (UINT8 fieldno, INT8 *pbuf, UINT16 *plen);
INT32	HOSTAPPINTERFACE_IsUIDValid (BOOL *pValid);
INT32	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq(UINT8 *count, UINT8 defCount);
INT32	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq(UINT8 count);
INT32	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt(UINT8 *count, UINT8 defCount);	
INT32	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt(UINT8 count);	
INT32	HOSTAPPINTERFACE_InitRoamingDescriptiveTable(void);
INT32	HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID(UINT8 *gwuid,UINT16 panid);

INT32 StartupWait(void);
INT32 RFConsolePrintf(const char* format,...);
INT32 RFErrorPrintf(const char* format,...);
INT32 ErrorHandler(char *msg);
INT32 IntfcHwDelayMsec(UINT32 ms);
INT32 IntfcHwDelayUsec(UINT32 us);
INT32 GetTime(long *time);
INT32 GetDate(short *month,short *day,short *year);
INT32 SystemError(int error);
INT32 GetAddressMode(UINT8 *addrMode, UINT8 defAddrMode);
INT32 StoreAddressMode(UINT8 addrMode);
INT32 GetShortAddress(UINT16 *shortAddr, UINT16 defShortAddr);
INT32 StoreShortAddress(UINT16 shortAddr);
INT32 AcquireStartIndication(void);
INT32 AcquireStopIndication(void);

extern long rfgettime(void);
extern void HwDelayMsec(UINT32 ms);
INT32 HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr (UINT8 *pLQI, UINT8 defaultLQI);
INT32 HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr (UINT8 LQI);

const TYPE_INTERFACE_TO_HOST_APP RFIntHostApp = {
	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE,	
	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID,
	HOSTAPPINTERFACE_StoreGatewayUID_PANID,
	HOSTAPPINTERFACE_StoreGatewayName,
	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID,
    HOSTAPPINTERFACE_StoreLocalDeviceUID,
    HOSTAPPINTERFACE_StoreLocalDevicePANID,
	HOSTAPPINTERFACE_ProcessCresnetPacket,
	HOSTAPPINTERFACE_LinkReply,
	HOSTAPPINTERFACE_RFCommunicationError,
	HOSTAPPINTERFACE_BufferOverFlows,
	HOSTAPPINTERFACE_ProcessLocalCresnetPacket,
	HOSTAPPINTERFACE_GetRetryCount,
	HOSTAPPINTERFACE_StoreRetryCount,
	HOSTAPPINTERFACE_GetRetryDelay,
	HOSTAPPINTERFACE_StoreRetryDelay,
	HOSTAPPINTERFACE_GetPowerLevel,
	HOSTAPPINTERFACE_StorePowerLevel,
	HOSTAPPINTERFACE_GetChannel,
	HOSTAPPINTERFACE_StoreChannel,
	HOSTAPPINTERFACE_GetCCAEnergyDetectThr,
	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr,
	HOSTAPPINTERFACE_GetRSSIPowerCompOffset,
	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset,
	HOSTAPPINTERFACE_GetResultCodeTimeout,
	HOSTAPPINTERFACE_StoreResultCodeTimeout,
	HOSTAPPINTERFACE_GetHeartBeatRate,
	HOSTAPPINTERFACE_StoreHeartBeatRate,
	HOSTAPPINTERFACE_GetIDString,
	HOSTAPPINTERFACE_AcquireUpdate,
	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange,
	HOSTAPPINTERFACE_GatewayConnectionStatusChange,
	HOSTAPPINTERFACE_GetRFID,
	HOSTAPPINTERFACE_GetTSID,
	HOSTAPPINTERFACE_GetDeviceOptions,
	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured,
	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled,
	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled,
    HOSTAPPINTERFACE_RFReceiverIndicatorFlash,
    HOSTAPPINTERFACE_RFTransmitIndicatorFlash,
	HOSTAPPINTERFACE_DeviceLinkLost,
	HOSTAPPINTERFACE_DeviceLinkFound,
	HOSTAPPINTERFACE_CalculateBlockCRC16,	
	HOSTAPPINTERFACE_GetDeviceDataField,
	StartupWait,
	RFConsolePrintf,
	RFErrorPrintf,
	ErrorHandler,
	IntfcHwDelayMsec,
	IntfcHwDelayUsec,
	GetTime,
	GetDate,
	SystemError,
	GetAddressMode,
	StoreAddressMode,
	GetShortAddress,
	StoreShortAddress,
	AcquireStartIndication,
	AcquireStopIndication,
	HOSTAPPINTERFACE_IsUIDValid,
	HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr, 
	HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr,
	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq,	
	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq,
	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt,
	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt,
	HOSTAPPINTERFACE_InitRoamingDescriptiveTable,
	HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID
};

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
//	EXTERNAL
////////////////////////////////////////////////////////////////////////////////
//INT8   *ConvertUIDtoString (UINT8 *puid, INT8 *pstr, UINT8 addrmode);

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// MNT - 3/21/2007 - Make sure that these functions do something. Most of the stuff is
// commented out but it should give the device developer an idea of what needs to be
// returned. All the EEProm Entries are specifically commented out for the user to define
// what that means (store in file system/nvram or whatever else makes sense)
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

INT32	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *pAddrMode, UINT8 *defUID, UINT16 defPanid, UINT8 defaddrMode)
{
    memcpy(pUID, &rfparam.gatewayUID[0], UID_MAX_SIZE);
    *pPanid = rfparam.gatewayPanID;

	*pAddrMode = defaddrMode;

	*pUIDValid = TRUE;

	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(BOOL *pUidValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *defUID, UINT16 defPanid)
{
    if (rfparamlocal.UID_Valid != UID_SIGN)
    {
        //Invalid ? For now just return the defaults
        memcpy(pUID, defUID, UID_MAX_SIZE);
        *pUidValid = 0;
        return 0;       // should be a zero return
    }
    memcpy(pUID, &rfparam.UID[0], UID_MAX_SIZE);
    *pPanid = rfparam.panID;

    *pUidValid = TRUE;

    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreGatewayUID_PANID(UINT8 *pUID, UINT16 panid, UINT8 addrmode)
{
	DWORD dwSize = sizeof(DWORD);
    UINT8 buf[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
    if (hPDSDriver == INVALID_HANDLE_VALUE)
    {
        RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
    }
	else
	{
		//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success: HOSTAPPINTERFACE_StoreGatewayUID_PANID\r\n")));
	}

	if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
		RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

	SetFilePointer(hPDSDriver,DS_UL_ER_GATEWAYPANID,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,&panid,sizeof(DWORD),&dwRet,NULL);

	SetFilePointer(hPDSDriver,DS_UC_ER_GATEWAYUID,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,pUID,UID_MAX_SIZE,&dwRet,NULL);

	CloseHandle(hPDSDriver);

    // Now update the local variable
    memcpy(rfparam.gatewayUID, pUID, UID_MAX_SIZE);
    rfparam.gatewayPanID = panid;
    // Local param string
    ConvertUIDtoString(pUID, buf, gAddrModeLong_c);
    strcpy(rfparamlocal.gatewayUIDString, buf);

    //RETAILMSG(1, (L"\r\nStored GW UPD PANID successfully."));
    //RETAILMSG(1, (L"\r\n GatewayPANID: 0x%x", rfparam.gatewayPanID));
    //RETAILMSG(1, (L"\r\n Acquired GatewayUID: %s", rfparamlocal.gatewayUIDString));

    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreGatewayName (UINT8 *pName)
{
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID(UINT8 *pUID, UINT16 PANID)
{
    return SUCCESS;
}


INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID(UINT8 *pUID)
{
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreLocalDevicePANID(UINT16 PANID)
{
    return SUCCESS;
}


INT32	HOSTAPPINTERFACE_ProcessCresnetPacket(UINT8 *pBuf, UINT16 BufLen)
{
    if(rfparam.RFGenericDebug)
    {
        RFConsolePrintf("Local Cresnet packet Len=%02x, data=%02x%02x%02x%02x\r\n", BufLen, *pBuf, *(pBuf+1), *(pBuf+2), *(pBuf+3));
    }
    SendCresnetPacketToApp((void*)pBuf, BufLen);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_LinkReply(BOOL Linked, BOOL CSStatus)
{
	if(rfparam.RFGenericDebug)
	    RFConsolePrintf("Link reply Linked=%d, CSStatus=%d\r\n", Linked, CSStatus);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_RFCommunicationError(BOOL SeqErr, BOOL SegErr)
{
	if(rfparam.RFGenericDebug)
	    RFConsolePrintf("CommError SeqErr=%d, SegErr=%d\r\n", SeqErr, SegErr);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_BufferOverFlows (BOOL TxBuf, BOOL RxBuf)
{
    char rf_restart_msg[] = {2,2,3,0};
    
    // Send Update request
    rf_restart_msg[0] = rfparam.RFID;
    // PRASAD - to do
    //RFIntRFApp.pF_PostCresnetPacket();
	if(rfparam.RFGenericDebug)
        RFConsolePrintf("Bufferoverflow TxBuf=%d, RxBuf=%d\r\n", TxBuf, RxBuf);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_EchoReply(UINT8 *pBuf, UINT8 BufLen)
{
	//	For debug purpose
	if(rfparam.RFGenericDebug)
	    RFConsolePrintf("Echo reply Len=%02x, Data=[%02x%02x%02x%02x%02x]\r\n", BufLen, *pBuf, *pBuf+1, *pBuf+2, *pBuf+3, *pBuf+4);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_ProcessLocalCresnetPacket(UINT8 *pBuf, UINT16 BufLen)
{
    if(rfparam.RFGenericDebug)
    {
	    RFConsolePrintf("Local Cresnet packet Len=%02x, data=%02x%02x%02x%02x\r\n", BufLen, *pBuf, *(pBuf+1), *(pBuf+2), *(pBuf+3));
    }
    SendLocalCresnetPacketToApp((void*)pBuf, BufLen);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetRetryCount(UINT8 *count, UINT8 defCount)
{
    // HS use this value in RF_PARAM unsigned char   retry; 7/9/2007 5:07PM
    //*count = defCount;
    *count= rfparam.retry;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreRetryCount(UINT8 count)
{
    //RF_SaveRetryCount(count);
    DWORD dwCount = (DWORD) count;
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	DWORD dwSize = sizeof(DWORD);
	hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
    if (hPDSDriver == INVALID_HANDLE_VALUE)
    {
        RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
    }
	else
	{
		//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success\r\n")));
	}

	if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
		RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

	SetFilePointer(hPDSDriver,DS_UL_ER_RETRY,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,&dwCount,sizeof(DWORD),&dwRet,NULL);

	CloseHandle(hPDSDriver);

    rfparam.retry = count;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetRetryDelay(UINT8 *RetryDly, UINT8 Cnt, UINT8 *defRetryDly)
{
    //retrydelay[RF_MAX_NO_OF_RETRIES_DELAYS]; use this HS 7/9/2007 5:09PM
	memcpy(RetryDly, defRetryDly, Cnt);
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreRetryDelay(UINT8 RetryDly, UINT8 Cnt)
{
    // HS will be done only by console. Fix "rfconfig 7/9/2007 5:10PM
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetPowerLevel(UINT16 *powerLevel, UINT16 defPowerLevel)
{
    //*powerLevel= (unsigned short) RF_GetPowerLevel();
    // PRASAD - to do. If telec test is running it has to return tele test power
	*powerLevel = rfparam.powerhilo;
	return (SUCCESS);
}
INT32	HOSTAPPINTERFACE_StorePowerLevel(UINT16 powerLevel)
{
    //RF_SavePowerLevel(powerLevel );
    DWORD dwPowerLevel = (DWORD) powerLevel;
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	DWORD dwSize = sizeof(DWORD);
	hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
    if (hPDSDriver == INVALID_HANDLE_VALUE)
    {
        RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
    }
	else
	{
		//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success\r\n")));
	}

	if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
		RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

	SetFilePointer(hPDSDriver,DS_UL_ER_POWERHILO,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,&dwPowerLevel,sizeof(DWORD),&dwRet,NULL);

	CloseHandle(hPDSDriver);

    rfparam.powerhilo = (UINT8)powerLevel;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetChannel	(UINT8 *Channel, UINT8 defChannel)
{
    if((rfparam.channel < RF_FIRST_CHANNEL) || (rfparam.channel > RF_LAST_CHANNEL))
    {
        *Channel = defChannel;
    }
    else
    {
        *Channel = rfparam.channel;
    }

	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreChannel (UINT8 Channel)
{
	//RF_SaveChannel(Channel);
    DWORD dwChannel = (DWORD)Channel;
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	DWORD dwSize = sizeof(DWORD);
	
	WCHAR szState[MAX_PATH];
	DWORD dwStateFlags = 0;

    if (GetSystemPowerState(szState, MAX_PATH, &dwStateFlags) == ERROR_SUCCESS)
    {
		if (!(dwStateFlags & POWER_STATE_SUSPEND))		// we are coming out of suspend
		{
			hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
			if (hPDSDriver == INVALID_HANDLE_VALUE)
			{
				RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
			}
			else
			{
				//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success\r\n")));
			}

			if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
				RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

			SetFilePointer(hPDSDriver,DS_UL_ER_CHANNEL,NULL,FILE_BEGIN);
			WriteFile(hPDSDriver,&dwChannel,sizeof(DWORD),&dwRet,NULL);

			CloseHandle(hPDSDriver);
		}
	}

    rfparam.channel = Channel;

    if (rfparam.RFGenericDebug)
        RFConsolePrintf("Gateway channel: %d \r\n", Channel);

    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetCCAEnergyDetectThr(UINT8 *ccaThres, UINT8 defCcaThres)
{
    // HS RFCONFIG command must set this and save to EEPARAM 7/9/2007 5:15PM
	//EEpromGetCCAEnergyDetectThr(&thr);
	//*ccaThres= RF_GetCCA();
	//*ccaThres = defCcaThres;
    *ccaThres = rfparam.CCAEnergyDetectThr;

    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr(UINT8 ccaThres)
{
    //RF_SaveCCA(ccaThres);
    DWORD dwCCAThres = (DWORD)ccaThres;
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	DWORD dwSize = sizeof(DWORD);
	hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
    if (hPDSDriver == INVALID_HANDLE_VALUE)
    {
        RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
    }
	else
	{
		//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success\r\n")));
	}

	if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
		RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

	SetFilePointer(hPDSDriver,DS_UL_ER_CCAENERGYDETECTTHR,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,&dwCCAThres,sizeof(DWORD),&dwRet,NULL);

	CloseHandle(hPDSDriver);

    rfparam.CCAEnergyDetectThr= ccaThres;
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_GetRSSIPowerCompOffset(UINT8 *rssiOffset, UINT8 defRssiOffset)
{
    //HS RFCONFIG command must set this and save to EEPARAM 7/9/2007 5:15PM
	//EEpromGetRSSIPowerCompOffset(&offset);
	//*rssiOffset= RF_GetRSSICOMP();
	//*rssiOffset = defRssiOffset;
    *rssiOffset = rfparam.RSSIPowerCompOffset;

    return SUCCESS;
}
INT32	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset(UINT8 rssiOffset)
{
    //RF_SaveRSSICOMP(rssiOffset);
    DWORD dwRSSIOffset = (DWORD)rssiOffset;
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	DWORD dwSize = sizeof(DWORD);
	hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
    if (hPDSDriver == INVALID_HANDLE_VALUE)
    {
        RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
    }
	else
	{
		//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success\r\n")));
	}

	if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
		RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

	SetFilePointer(hPDSDriver,DS_UL_ER_RSSIPOWERCOMPOFFSET,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,&dwRSSIOffset,sizeof(DWORD),&dwRet,NULL);

	CloseHandle(hPDSDriver);

    rfparam.RSSIPowerCompOffset = rssiOffset;
    return (SUCCESS);
}
INT32	HOSTAPPINTERFACE_GetResultCodeTimeout(UINT16 *timeout, UINT16 defTimeout)
{
    //HS RFCONFIG command must set this and save to EEPARAM 7/9/2007 5:16PM
	//EEpromGetResultCodeTimeout (&resultcode);
	*timeout = defTimeout;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreResultCodeTimeout(UINT16 timeout)
{
    // Not needed HS 7/9/2007 5:16PM
    return SUCCESS;
}
INT32	HOSTAPPINTERFACE_GetHeartBeatRate(UINT8 *heartBeatRate, UINT8 defHeartBeatRate)
{
    //HS RFCONFIG command must set this and save to EEPARAM 7/9/2007 5:16PM
	//EEpromGetHeartBeatTimeout (&heartbeat);
	*heartBeatRate = defHeartBeatRate;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreHeartBeatRate(UINT8 heartBeatRate)
{
    // Not needed 7/9/2007 5:17PM
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetIDString(INT8 *pBuf, UINT8 * count)
{
	*count = strlen(bootidmsg);
	memcpy((void*)pBuf, (void*)bootidmsg, *count);
	return SUCCESS;

}

INT32	HOSTAPPINTERFACE_AcquireUpdate(TYPE_GATEWAY_IN_ACQUIRE_LIST* pAcquireResult, UINT8 NoofAcquireEntries, BOOL Finished)
{
    INT8	buf[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN], i;
    if (NoofAcquireEntries)
    {
	    for (i=0; i<NoofAcquireEntries; i++, pAcquireResult++)
        {
	        RFConsolePrintf("Acquire %d in acquire: name[%s] uid[%s] panid[%04x] channel[%02x]\r\n", i, (INT8*)&pAcquireResult->name,
		                	ConvertUIDtoString((UINT8*)&pAcquireResult->uid, buf, gAddrModeLong_c), pAcquireResult->panid, pAcquireResult->channel);
			if (i == 0)
            {
			    HOSTAPPINTERFACE_StoreGatewayUID_PANID((UINT8*)&pAcquireResult->uid, (UINT16) pAcquireResult->panid, (UINT8) pAcquireResult->addrmode);
			    HOSTAPPINTERFACE_StoreChannel ((UINT8) pAcquireResult->channel);
                //RF_Acquire_Stop(1);
                //RF_Acquire_Report_Status(pAcquireResult->name, buf);
                    
                // Copy acquired gateway name to local variable
                // Note Gateway UID string is stored in StoreGatewayUID_PANID function
                strcpy((char*)rfparamlocal.gatewayName, pAcquireResult->name);

                // Copy GW name to local buffer for the application.
                strcpy(&buf[1], pAcquireResult->name);
                    
                buf[0] = HPRF_CTRL_MSG_ACQUIRE_SUCCESS;
                SendCtrlMsgToApp((void*)buf, sizeof (buf));
		if(g_roamingEnabled)
                {
                    // PRASAD - to do.
				    //RF_Acquire_Report_Roaming_Entry_Status(pAcquireResult->name, buf);
				    //RF_StoreGatewayNamesToFlash();
				}
                //RF_PrintAcquireStatus(pAcquireResult->name);    // PM 02.29.2008: Print gateway name
			}
		}
	}
    else
    {
	    //RF_Acquire_Stop(2);
        buf[0] = HPRF_CTRL_MSG_ACQUIRE_TIMEOUT;
        SendCtrlMsgToApp((void*)buf, sizeof (buf));
		RFConsolePrintf("Acquire done: no gateway found in acquire mode\r\n");
	}
	RFIntRFApp.pF_AcquireStop(TRUE);

	//HOSTAPPINTERFACE_GetChannel(&channel, SLAVE_DEVICE_DEFAULT_CHANNEL);	
	//HOSTAPPINTERFACE_GetGatewayUID_PANID(&gatewayuidvalid, gatewayuid, &gatewaypanid, gatewayaddrmode, (UINT8 *)GATEWAY_DEFAULT_UID, GATEWAY_DEFAULT_PANID, GATEWAY_ADDR_MODE);	
	//RFIntRFApp.pF_ConnectDeviceToNetwork (gatewayuid, gatewaypanid, channel, gatewayaddrmode);
	//	or
	//RFIntRFApp.LookupSettingsAndConnectDeviceToNetwork();
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange(BOOL CSStatus, BOOL SendUpdateReq)
{
    char buf[4];
    
    if (CSStatus == TRUE)
    {
        buf[0] = HPRF_CTRL_MSG_CTRL_SYS_CONNECTED;
        buf[1] = (char) SendUpdateReq;
    }
    else
    {
        buf[0] = HPRF_CTRL_MSG_CTRL_SYS_DISCONNECTED;
        buf[1] = (char) SendUpdateReq;
    }
    SendCtrlMsgToApp((void*)buf, sizeof (buf));

    //RF_ControlSystemConnectionStatusChange(CSStatus, SendUpdateReq);
    RFConsolePrintf("Control System connect update Status=%d, updreq=%s\r\n", CSStatus, SendUpdateReq?"TRUE":"FALSE");
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GatewayConnectionStatusChange(BOOL Status)
{
    char buf[GATEWAY_NAME_MAX_SIZE + 8];
    INT8 idstring[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN+1];
	
    if (Status)
    {
        // Update gateway name
        strncpy((char *)idstring,(char *)g_pRFDeviceDescriptiveTable[DEVICE_DESCRIPTIVE_TABLE_INDEX].IDInfo.idstring, RF_DEVICE_MAX_CRESNET_ID_STRING_LEN);

        strncpy(rfparamlocal.gatewayName, (char*) idstring, GATEWAY_NAME_MAX_SIZE);
        strncpy(&buf[1], (char*) idstring, GATEWAY_NAME_MAX_SIZE);
        // Update strings
        buf[0] = HPRF_CTRL_MSG_GW_CONNECTED;

		//	gateway connection established		
		RFIntRFApp.pF_PrepareAndPostDeviceDataInfoStr (RF_DEVICE_INFO_CRC_FIELD_INDEX);
	}
    else	
    {
		//	gateway connection lost
        // Inform application
        buf[0] = HPRF_CTRL_MSG_GW_DISCONNECTED;
	}
    // Inform the application about the status change
    SendCtrlMsgToApp((void*)buf, sizeof (buf));
    
    //RF_GatewayConnectionStatus(Status);
	RFConsolePrintf("Host: Gateway connection status = %x \r\n", Status);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetRFID(UINT8 *rfID)
{
    *rfID = rfparam.RFID;	
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetTSID(UINT32 *tsID)
{
    //*tsID= param.PPN_Address;
    *tsID = rfparamlocal.TSID;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetDeviceOptions (UINT8 *devOpts)
{
	*devOpts = 0x11;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured (UINT32 index)
{
	RFConsolePrintf ("RFTransmit Pipe overflow occured \r\n");
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (BOOL *isEnabled)
{
	*isEnabled = rfparam.RFTxDebug;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled (BOOL *isEnabled)
{
	*isEnabled = rfparam.RFRxDebug;
	return SUCCESS;
}



INT32   HOSTAPPINTERFACE_RFReceiverIndicatorFlash(void)
{
    return SUCCESS;
}

INT32   HOSTAPPINTERFACE_RFTransmitIndicatorFlash(void)
{
    return SUCCESS;
}

INT32 GetAddressMode(UINT8 *addrMode, UINT8 defAddrMode)
{
	// MNT - 3/21/2007 - Make sure this is modified!!!!!!!
	// Do not use this value
	*addrMode = defAddrMode;
	return SUCCESS;
}


INT32 GetShortAddress(UINT16 *shortAddr, UINT16 defShortAddr)
{
	// MNT - 3/21/2007 - Make sure this is modified!!!!!!!
	// Do not use this value
	*shortAddr = defShortAddr;
	return SUCCESS;
}


INT32 GetDate(short *month,short *day,short *year)
{
    // PRASAD - to do
    //getdate(month, day, year);
    return SUCCESS;
}



INT32 GetTime(long *time)
{
    // PRASAD - to do
    return SUCCESS;
}

INT32 IntfcHwDelayMsec(UINT32 ms)
{
    Sleep(ms);
    return SUCCESS;
}

INT32 IntfcHwDelayUsec(UINT32 us)
{
    StallExecution(us);
    return SUCCESS;
}


INT32 StartupWait(void)
{
    // MNT needs this 7/9/2007 5:22PM
    return SUCCESS;
}


INT32 SystemError(int error)
{
    // Error log ?? MNT 7/9/2007 5:22PM
    //RETAILMSG(1, (L"System Error: 0x%02x\r\n", error));
    RFErrorPrintf("System Error: 0x%02x\r\n", error);
	return SUCCESS;
}


INT32 ErrorHandler(char *msg)
{
    return RFConsolePrintf(msg);
}


INT32 AcquireStartIndication(void)
{
    return SUCCESS;
}

INT32 AcquireStopIndication(void)
{
    return SUCCESS;
}

INT32 StoreAddressMode(UINT8 addrMode)
{
    //HS from console 7/9/2007 5:23PM
    return SUCCESS;
}

INT32 StoreShortAddress(UINT16 shortAddr)
{
     //HS from console 7/9/2007 5:23PM
    return SUCCESS;
}


/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function is called when an device rf link is lost
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval
 *
 * \param		void
 * \return
 */
INT32 HOSTAPPINTERFACE_DeviceLinkLost (UINT8 rfid)
{
	RFConsolePrintf ("RFDevice [%02X] Link Lost\r\n", rfid);
	return (SUCCESS);
}

/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function is called when an rf device is linked
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval
 *
 * \param		void
 * \return
 */
INT32 HOSTAPPINTERFACE_DeviceLinkFound (UINT8 rfid)
{
	RFConsolePrintf ("RFDevice [%02X] Linked \r\n", rfid);
	return (SUCCESS);
}

/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function gets device data field information from the host application   
 *
 * \detail      
 *
 * \return      INT32
 *
 * \retval		SUCCESS/FAILURE      
 *
 * \param		UINT8 field, INT8 *pbuf, UINT16 *len  
 *
 * \return 
 */
INT32 HOSTAPPINTERFACE_GetDeviceDataField (UINT8 field, INT8 *pbuf, UINT16 *plen)
{
#if 0       // PRASAD - to do. See if we need this.
    //	test
	if (field < RF_DEVICE_INFO_MAX_DATA_FIELDS)
    {
#if (f_TOOLBOX_STRING_SUPPORT == USED)
		RF_GetFieldInfo(field, pbuf, plen);
#else
        *plen = sprintf (pbuf, "test string field %d", field);
#endif
	}	else
    {
		*pbuf = 0;	*plen = 0;
	}
#endif
	return (SUCCESS);
}

/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function calculate the passed ob block CRC    
 *
 * \detail      
 *
 * \return      INT32
 *
 * \retval      
 *
 * \param		UINT16 *crc, INT8 *pbuf, UINT16 len  
 *
 * \return 
 */
INT32	HOSTAPPINTERFACE_CalculateBlockCRC16 (UINT16 len, UINT16 *crc, INT8 *pbuf)
{
	UINT16 calccrc = CalculateBlockCRC16( len, *crc, (void*)pbuf);
	*crc =  calccrc;

	return (SUCCESS);
}

/**
 *
 * \date        07-26-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function checks whether the UID is valid 
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval		SUCCESS, FAILURE
 *
 * \param		void
 *
 * \return
 */
INT32	HOSTAPPINTERFACE_IsUIDValid (BOOL *pUIDValid)
{
	UINT8	uid[UID_MAX_SIZE];
	UINT16	panid;	

	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(pUIDValid, uid, &panid, (UINT8 *)SLAVE_DEVICE_DEFAULT_UID, SLAVE_DEVICE_DEFAULT_PANID);
	
	return (SUCCESS);
}

/**
 *
 * \date        09-25-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function retrieves the link process LQI threshold from host
 *				
 * \detail
 *
 * \return      INT32
 *
 * \retval		SUCCESS, FAILURE
 *
 * \param		UINT8 *pLQI, UINT8 defaultLQI
 *
 * \return
 */
INT32 HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr (UINT8 *pLQI, UINT8 defaultLQI)
{
	INT32	res = SUCCESS;
	//res = (INT32)EEpromGetRFLinkLQIThr(pLQI);
	*pLQI = defaultLQI;
	return (res);	
}

/**
 *
 * \date        09-25-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function saves the link process LQI threshold  
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval		SUCCESS, FAILURE
 *
 * \param		UINT8 LQI
 *
 * \return
 */
INT32 HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr (UINT8 LQI)
{
	INT32	res = SUCCESS;
	//res = (INT32)EEpromSaveRFLinkLQIThr(LQI);
	return (res);	

}

INT32	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq(UINT8 *count, UINT8 defCount)
{
	//INT32 res = (INT32)EEpromGetRetryOnConnectionReq ((UINT8 *)  count);
	*count = rfparam.txPktretryonconnection;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq(UINT8 count)
{
    //INT32 res = (INT32)EEpromSaveRetryOnConnectionReq(count);
    DWORD dwCount = (DWORD)count;
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	DWORD dwSize = sizeof(DWORD);
	hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
    if (hPDSDriver == INVALID_HANDLE_VALUE)
    {
        RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
    }
	else
	{
		//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success\r\n")));
	}

	if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
		RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

	SetFilePointer(hPDSDriver,DS_UL_ER_TXPKTRETRYCONNECTION,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,&dwCount,sizeof(DWORD),&dwRet,NULL);

	CloseHandle(hPDSDriver);

    rfparam.txPktretryonconnection = count;
    return SUCCESS;
}


INT32	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt(UINT8 *count, UINT8 defCount)
{
	INT32 res = SUCCESS;	//	res = (INT32)EEpromGetPreLinkQueryPacketCnt ((UINT8*)  count);
    *count = rfparam.PreLinkQueryPacketCnt;
	return res;
}

INT32	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt(UINT8 count)
{
	INT32 res = SUCCESS;	//	res = (INT32)EEpromSavePreLinkQueryPacketCnt(count);

    DWORD dwCount = (DWORD)count;
	HANDLE hPDSDriver;
	DWORD dwRet;
	DWORD dwStatus;
	DWORD dwSize = sizeof(DWORD);
	hPDSDriver = CreateFile(TEXT("PDS1:"),GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,NULL);
    if (hPDSDriver == INVALID_HANDLE_VALUE)
    {
        RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Failed to open PDS1 handle.\r\n")));
    }
	else
	{
		//RETAILMSG(1, (TEXT("\r\nHPRF_ReadWriteEEPROM CreateFile Success\r\n")));
	}

	if(!(SetFilePointer(hPDSDriver,0,NULL,FILE_END) >= SYSTEM_STORAGE_SIZE))
		RETAILMSG(1, (TEXT("\r\nERROR HPRF_ReadWriteEEPROM: - Invalid Size.\r\n")));

	SetFilePointer(hPDSDriver,DS_UL_ER_PRELINKQUERYPAKCETCNT,NULL,FILE_BEGIN);
	WriteFile(hPDSDriver,&dwCount,sizeof(DWORD),&dwRet,NULL);

	CloseHandle(hPDSDriver);

    rfparam.PreLinkQueryPacketCnt = count;

	return res;
}
/**
 *
 * \author      John Cheng	
 *
 * \brief		to init. roaming table at power up
 *
 *
 * \detail			 
 *
 * \date        12/23/2008
 *
 * \param	    none		
 *
 * \return		SUCCESS 	 				
 *
 * \retval		SUCCESS for now 	 	  
 */	
INT32	HOSTAPPINTERFACE_InitRoamingDescriptiveTable(void)
{
	INT32 res = SUCCESS;    
    // PRASAD - to do for roaming
    //RF_RetrieveRoamingGatewayUID_PANID();
	//RF_RetrieveRoamingGatewayName();
	//RF_RoamingGatewayLQReset();
	return res;
}
/**
 *
 * \author      john Cheng	
 *
 * \brief		to store roaming info to flash
 *
 *
 * \detail			 
 *
 * \date        12/23/2008
 *
 * \param	    UINT8 *gwuid,UINT16 panid		
 *
 * \return		INT32 	 				
 *
 * \retval		SUCCESS	 	  
 */	
INT32   HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID(UINT8 *gwuid,UINT16 panid)
{
	INT32 res = SUCCESS;
    // PRASAD - to do for roaming
    //RF_SetRoamingGatewayUID_PANID
	return res;
}


INT32 RFConsolePrintf(const char* format,...)
{
    char    *s;
	int len;

    HPR_TY_DiagData Diag;
    va_list ap;

    // Just like TPS-6X
    if(rfparam.RFGenericDebug == 0)
    {
        return 0;
    }

    // Console printf data
    Diag.dwDataCode = HPRF_DIAG_DATA_CONSOLE_PRINT;

    s = (char *)Diag.Data.Console.buffer;
    va_start(ap,format);
    len = _vsnprintf(s, sizeof(Diag.Data.Console.buffer),format,ap);
    va_end(ap);
	
    // Print message (use RETAIL messages too)
    RETAILMSG(1, (L"%S", s));
    // Send to application
    Diag.Data.Console.dwStrLen = len;
    SendDiagDataToApp(&Diag, sizeof (HPR_TY_DiagData));

    return len;
}


INT32 RFErrorPrintf(const char* format,...)
{
    char    *s;
    int len = 0;
    va_list ap;

#ifdef HPRF_ERR_MSG_LOG
    // Static pointer to fill up the error log buffer..
    static CHAR* pPtr = RfErrorLog.RFErrorMsgBuff;

    // If some one resets the error log, we start from beginning..
    if (RfErrorLog.NoErrorMsgs == 0)
    {
        pPtr = RfErrorLog.RFErrorMsgBuff;
    }

    // Leave room for last message....
    if (RfErrorLog.TotalBytes < (HPRF_ERR_MSG_LOG_BUF_SIZE - 256))
    {
        s = (char *)pPtr;
        va_start(ap,format);
        len = _vsnprintf(s, 256, format, ap);
        va_end(ap);

        // Count the NULL also.
        RfErrorLog.TotalBytes += (len+1);
        RfErrorLog.NoErrorMsgs++;
        // Advance the pointer...
        pPtr = pPtr + len + 1;
    }
#else
    char    sArray[256];
    s = (char *) &sArray[0];
    va_start(ap,format);
    len = _vsnprintf(s, sizeof(sArray),format,ap);
    va_end(ap);
	RETAILMSG(1, (L"%S", s));
#endif
    return len;
}
